IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLES
			 WHERE TABLE_NAME='PRC_FILIAL_PW_ORDEM_ENVIO')
BEGIN
CREATE TABLE [dbo].[PRC_FILIAL_PW_ORDEM_ENVIO](
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[ORDEM_ENVIO] [int] NOT NULL,
	[CD_USU] [int] NOT NULL,
	[DT_CAD] [datetime] NOT NULL,
 CONSTRAINT [PK_PRC_FILIAL_PW_ORDEM_ENVIO] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[ORDEM_ENVIO] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[PRC_FILIAL_PW_ORDEM_ENVIO] ADD  CONSTRAINT [DF_PRC_FILIAL_PW_ORDEM_ENVIO_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[PRC_FILIAL_PW_ORDEM_ENVIO] ADD  CONSTRAINT [DF_PRC_FILIAL_PW_ORDEM_ENVIO_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[PRC_FILIAL_PW_ORDEM_ENVIO] ADD  CONSTRAINT [DF_PRC_FILIAL_PW_ORDEM_ENVIO_ORDEM_ENVIO]  DEFAULT ((0)) FOR [ORDEM_ENVIO]

ALTER TABLE [dbo].[PRC_FILIAL_PW_ORDEM_ENVIO] ADD  CONSTRAINT [DF_PRC_FILIAL_PW_ORDEM_ENVIO_CD_USU]  DEFAULT ((0)) FOR [CD_USU]

ALTER TABLE [dbo].[PRC_FILIAL_PW_ORDEM_ENVIO] ADD  CONSTRAINT [DF_PRC_FILIAL_PW_ORDEM_ENVIO_DT_CAD]  DEFAULT (getdate()) FOR [DT_CAD]

ALTER TABLE [dbo].[PRC_FILIAL_PW_ORDEM_ENVIO]  WITH CHECK ADD  CONSTRAINT [FK_PRC_FILIAL_PW_ORDEM_ENVIO_PRC_FILIAL] FOREIGN KEY([CD_EMP], [CD_FILIAL])
REFERENCES [dbo].[PRC_FILIAL] ([CD_EMP], [CD_FILIAL])

ALTER TABLE [dbo].[PRC_FILIAL_PW_ORDEM_ENVIO] CHECK CONSTRAINT [FK_PRC_FILIAL_PW_ORDEM_ENVIO_PRC_FILIAL]
end